/***********************************************************
	error.c -- error processing
***********************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include "lh.h"
#include "errmes.h"

/*******************************
	process for error
*******************************/
void error(char *errmes, char *p)
{
	if (file1 != NULL) {
		fclose(file1);
		if (cmdupdate)					/* during updating */
			rename(filename1, arcname);	/* recover old archive */
	}
	if (errmes == COPYERR) {			/* error during copying temporary? */
		fclose(file2);
		eprintf(COPYERR, filename2);
		exit(3);
	}
	if (file3 != NULL) {
		fclose(file3);
		if (cmd == 'E')					/* during extracting */
			remove(filename3);			/* delete the file */
	}
	if (file2 != NULL) {
		fclose(file2);
		remove(filename2);				/* delete temporary */
	}
	eprintf("\n%s", errmes);
	if (p) {
		eprintf(" : '%s'", p);
	}
	eprintf("\n");
	exit(2);
}

void fileerror(char *err, FILE *file)
{
	char *name;

	name = NULL;
	if (file == file1) name = filename1;
	if (file == file2) name = filename2;
	if (file == file3) name = hpb.pathname;
	error(err, name);
}

/*******************************
		handle user break
*******************************/
void break_get_on(void);
void break_off(void);
void break_set(void);

void userbreak(int code)
{
	break_off();
	error(CTRLBRK, NULL);
}

void initbreak(void)
{
	signal(SIGINT, userbreak);
	break_get_on();
	atexit(break_set);
}
